Attribute VB_Name = "eStarModule"
'Option Explicit

Public hcomm_public As Long

'Return the number of USB devices get connected
Public Declare Function API_USBGetConnectedDeviceNum Lib "HIDdll.DLL" () As Long

'Open the USB device
Public Declare Function API_USBOpenWithNum Lib "HIDdll.DLL" (ByRef hcomm As Long, _
                                                             ByVal deviceIndex As Long, _
                                                             ByVal numInputBuffers As Byte) _
                                                             As Long

'Close the connection
Public Declare Function API_USBCloseComm Lib "HIDdll.DLL" (ByVal commHandle As Long) As Boolean


''Data transfer channel on the protocol of the company
Public Declare Function API_USBAll Lib "HIDdll.DLL" (ByVal commHandle As Long, _
                                                     ByVal cmdSize As Long, _
                                                     ByRef cmd As Byte, _
                                                     ByRef returnlen As Byte, _
                                                     ByRef pBuffer As Byte) _
                                                     As Long



'-------------------------------------------------------------------------------------
'--------------------     ESTAR READER RE-INITIALISATION     -------------------------
'-------------------------------------------------------------------------------------

Public Function detect_ESTAR_reInit() As Boolean
Dim i As Long
Dim j As Long
Dim deviceIndex As Integer
Dim numInputBuffersInt As Integer
Dim status As Long
Dim bstatus As Boolean
Dim strDataMsg As String
    
If (hcomm_public > 0) Then
    
    'Close eStar USB connection
    bstatus = API_USBCloseComm(hcomm_public)
    
    'Open a new USB connection
    status = API_USBGetConnectedDeviceNum()
    
    If (status > 0) Then
        detect_ESTAR_reader = True
        deviceIndex = 0
        numInputBuffersInt = 64
        status = API_USBOpenWithNum(hcomm_public, deviceIndex, numInputBuffersInt)
        strDataMsg = "new eStar USB hanlde : " & hcomm_public
        Call MsgBox(strDataMsg, vbInformation, "ESTAR reader")
    Else
        detect_ESTAR_reader = False
        strDataMsg = "ESTAR reader problem" & vbCr & "please disconnect USB cable and connect it again"
        Call MsgBox(strDataMsg, vbInformation, "ESTAR reader")
        End
    End If
    

End If

End Function

Public Function detect_ESTAR_reConnected() As Boolean
Dim i As Long
Dim deviceIndex As Integer
Dim numInputBuffersInt As Integer
Dim status As Long
Dim bstatus As Boolean
Dim strDataMsg As String
Dim strAnswerDatas As String

'Estar
Dim lngEstarCmdSize As Long
Dim pEstarCmd(0 To 63) As Byte
Dim pEstarAnswerSize(0 To 63) As Byte
Dim pEstarAnswer(0 To 63) As Byte

'Call cmdScanUSBreaders_Click
status = API_USBGetConnectedDeviceNum()

If (status > 0) Then

    detect_ESTAR_reConnected = True
    deviceIndex = 0
    numInputBuffersInt = 64
    'Open Connection and Get Device Handle
        status = API_USBOpenWithNum(hcomm_public, deviceIndex, numInputBuffersInt)
        'txt_estar_deviceHandle.Text = hcomm_public
    'Get Version
        strRequestDatas = gstr_estar_0xB8_cmd_GET_VERSION
        lngEstarCmdSize = Len(strRequestDatas) / 2
        For j = 0 To lngEstarCmdSize - 1
             pEstarCmd(j) = CByte("&h" & Mid(strRequestDatas, (j * 2) + 1, 2))
        Next j
        DoEvents
        lngStatus = API_USBAll(hcomm_public, lngEstarCmdSize, pEstarCmd(0), pEstarAnswerSize(0), pEstarAnswer(0))
        For i = 1 To pEstarAnswerSize(0)
            strAnswerDatas = strAnswerDatas & " " & i2hhh(CLng(pEstarAnswer(i - 1)), 2)
        Next i
        DoEvents

Else
   
    detect_ESTAR_reConnected = False
    strDataMsg = "ESTAR reader USB problem" & vbCr & _
                 "please close the Application software" & vbCr & _
                 "disconnect USB cable and try again "
    Call MsgBox(strDataMsg, vbInformation, "ESTAR reader")

End If

End Function

Public Function i2hhh(i As Long, digit As Byte) As String
Dim strHexa As String

  strHexa = Hex(i)

  Select Case (digit - Len(strHexa))
  Case 0
    i2hhh = strHexa
  Case 1
    i2hhh = "0" & strHexa
  Case 2
    i2hhh = "00" & strHexa
  Case 3
    i2hhh = "000" & strHexa
  Case 4
    i2hhh = "0000" & strHexa
  Case 5
    i2hhh = "00000" & strHexa
  Case 6
    i2hhh = "000000" & strHexa
  Case 7
    i2hhh = "0000000" & strHexa
  Case Else
    i2hhh = strHexa
  End Select

End Function

